<?php
session_start();

// Gate: letter_admin only
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'letter_admin') {
    header('Location: unauthorized.php');
    exit();
}

require_once 'db_connection.php';

// Initialize filter vars (kept for future use if you add a filter bar)
$start_date = $end_date = $branch_id = "";

// COUNT KPIs
// (Kept close to your original logic; adjust conditions if your schema differs)
$sql = "
  SELECT 
    COUNT(CASE WHEN l.status_branch_head = 'pending' THEN 1 END)                  AS pending_count,
    COUNT(CASE WHEN l.status_branch_head = 'received' THEN 1 END)                 AS received_count,
    COUNT(CASE WHEN l.seen = 1 THEN 1 END)                                        AS seen_count,
    COUNT(CASE WHEN l.action = 'yes' THEN 1 END)                                  AS action_count,
    COUNT(CASE WHEN (l.action IS NULL OR l.action = '' OR l.action = 'no') THEN 1 END) AS no_action_count,
    COUNT(CASE WHEN (l.seen = 0 OR l.seen IS NULL) THEN 1 END)                    AS not_seen_count
  FROM letters l
  WHERE 1 = 1
";

// Optional filters (currently not rendered in UI, but ready)
if (!empty($_POST['start_date']) && !empty($_POST['end_date'])) {
    $start_date = $_POST['start_date'];
    $end_date   = $_POST['end_date'];
    $sql .= " AND l.letter_date BETWEEN '" . $conn->real_escape_string($start_date) . "' 
                                 AND '" . $conn->real_escape_string($end_date)   . "'";
}
if (!empty($_POST['branch_id'])) {
    $branch_id = (int)$_POST['branch_id'];
    $sql .= " AND l.branch_id = {$branch_id}";
}

$res = $conn->query($sql);
$pending_count   = $received_count = $seen_count = $action_count = $no_action_count = $not_seen_count = 0;

if ($res && ($row = $res->fetch_assoc())) {
  $pending_count   = (int)$row['pending_count'];
  $received_count  = (int)$row['received_count'];
  $seen_count      = (int)$row['seen_count'];
  $action_count    = (int)$row['action_count'];
  $no_action_count = (int)$row['no_action_count'];
  $not_seen_count  = (int)$row['not_seen_count'];
}

// For sidebar badge examples (optional); or remove if not needed
$branches = $conn->query("SELECT branch_id, branch_name FROM branches");

$username = htmlspecialchars($_SESSION['username'] ?? 'User', ENT_QUOTES, 'UTF-8');
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>Letter Admin – Dashboard</title>

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH"
        crossorigin="anonymous">
  <!-- Font Awesome -->
  <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"
        referrerpolicy="no-referrer"/>

  <style>
    :root{
      --brand:#0d6efd; --brand-2:#5aa2ff; --sidebar:#1f2430; --sidebar-hover:#2b3140; --bg:#f6f8fb;
    }
    body{ background:var(--bg); }

    /* Sidebar (offcanvas on mobile, fixed on lg+) */
    .sidebar-fixed {
      width:260px; position:fixed; inset:0 auto 0 0;
      background:var(--sidebar); color:#e9ecef; padding:1rem .75rem;
      box-shadow: 2px 0 16px rgba(0,0,0,.12); display:none;
    }
    @media (min-width:992px){ .sidebar-fixed{ display:block; } main{ margin-left:260px; } }

    .sidebar-brand{
      display:flex; align-items:center; gap:.6rem; padding:.75rem .5rem;
      border-bottom:1px solid rgba(255,255,255,.08); margin-bottom:.5rem;
    }
    .sidebar-brand img{ width:38px; height:38px; object-fit:cover; border-radius:.55rem; border:2px solid rgba(255,255,255,.25); }

    .nav-sidebar .nav-link{ color:#e9ecef; border-radius:.6rem; padding:.55rem .65rem; display:flex; align-items:center; gap:.6rem; }
    .nav-sidebar .nav-link:hover{ background:var(--sidebar-hover); color:#fff; }
    .nav-sidebar .badge{ background:rgba(255,255,255,.12); border:1px solid rgba(255,255,255,.2); }

    /* App bar */
    .appbar{
      background:linear-gradient(135deg, var(--brand), var(--brand-2));
      color:#fff; padding:.85rem 1rem; display:flex; justify-content:space-between; align-items:center;
      position:sticky; top:0; z-index:1020; box-shadow:0 6px 24px rgba(13,110,253,.25);
    }
    .appbar .badge{
      background: rgba(255,255,255,.15); color:#fff; border:1px solid rgba(255,255,255,.25);
    }

    /* KPI cards */
    .kpi.card{ border:none; border-radius:1rem; box-shadow:0 10px 30px rgba(0,0,0,.06); }
    .kpi .icon{
      width:44px; height:44px; border-radius:.8rem; display:flex; align-items:center; justify-content:center;
      background:rgba(13,110,253,.12); color:var(--brand);
    }
    .kpi .value{ font-size:1.6rem; font-weight:800; }
    .kpi .label{ color:#6c757d; }

    /* Tiles */
    .btn-tile{
      display:flex; justify-content:space-between; align-items:center; gap:.75rem;
      border-radius:.9rem; padding:.9rem 1rem; width:100%;
      box-shadow:0 8px 24px rgba(0,0,0,.06);
    }
    .btn-tile .count.badge{
      background:#fff; color:#0b1320; border:1px solid rgba(0,0,0,.1);
    }

    .section-title{ font-weight:800; color:#0b1320; margin:1.25rem 0 .75rem; }
    .logo-square{ width:44px; height:44px; object-fit:cover; border-radius:.6rem; border:2px solid rgba(255,255,255,.35); }
  </style>
</head>
<body>

<!-- Offcanvas (mobile) -->
<div class="offcanvas offcanvas-start" tabindex="-1" id="mobileSidebar" aria-labelledby="mobileSidebarLabel">
  <div class="offcanvas-header">
    <h6 class="offcanvas-title" id="mobileSidebarLabel">Letter Admin</h6>
    <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
  </div>
  <div class="offcanvas-body p-0">
    <div class="px-3 pb-2">
      <a class="navbar-brand d-flex align-items-center gap-2" href="#">
        <img src="logo1.png" alt="Logo" width="32" height="32" onerror="this.style.display='none'">
        <span class="fw-semibold">Valvettithurai UC</span>
      </a>
    </div>
    <nav class="nav flex-column nav-pills nav-sidebar px-2 pb-3">
      <a class="nav-link" href="file_entry.php"><i class="fa-solid fa-file-arrow-up"></i><span class="ms-2">File input</span></a>
      <a class="nav-link" href="report.php"><i class="fa-solid fa-chart-line"></i><span class="ms-2">Report</span></a>
      <a class="nav-link" href="view_letters_statistics.php"><i class="fa-solid fa-gauge"></i><span class="ms-2">Letter Statistics</span></a>
      <a class="nav-link" href="enter_letter.php"><i class="fa-solid fa-pen-to-square"></i><span class="ms-2">Assign Letters</span></a>
      <a class="nav-link" href="staff.php"><i class="fa-solid fa-users"></i><span class="ms-2">Staff Letter</span></a>
      <a class="nav-link text-danger" href="logout.php"><i class="fa-solid fa-right-from-bracket"></i><span class="ms-2">Logout</span></a>
    </nav>
  </div>
</div>

<!-- Fixed Sidebar (lg+) -->
<aside class="sidebar-fixed d-none d-lg-block">
  <div class="sidebar-brand">
    <img src="logo1.png" alt="Logo" onerror="this.style.display='none'">
    <div>
      <div class="fw-bold">Letter Admin</div>
      <small class="text-white-50">Valvettithurai UC</small>
    </div>
  </div>
  <nav class="nav flex-column nav-sidebar">
    <a class="nav-link" href="file_entry.php"><i class="fa-solid fa-file-arrow-up"></i><span class="ms-2">File input</span></a>
    <a class="nav-link" href="report.php"><i class="fa-solid fa-chart-line"></i><span class="ms-2">Report</span></a>
    <a class="nav-link" href="view_letters_statistics.php"><i class="fa-solid fa-gauge"></i><span class="ms-2">Letter Statistics</span></a>
    <a class="nav-link" href="enter_letter.php"><i class="fa-solid fa-pen-to-square"></i><span class="ms-2">Assign Letters</span></a>
    <a class="nav-link" href="staff.php"><i class="fa-solid fa-users"></i><span class="ms-2">Staff Letter</span></a>
    <a class="nav-link text-danger" href="logout.php"><i class="fa-solid fa-right-from-bracket"></i><span class="ms-2">Logout</span></a>
  </nav>
</aside>

<!-- Main -->
<main>
  <!-- App bar -->
  <div class="appbar">
    <div class="d-flex align-items-center gap-2">
      <button class="btn btn-light d-lg-none me-2" type="button"
              data-bs-toggle="offcanvas" data-bs-target="#mobileSidebar"
              aria-controls="mobileSidebar" aria-label="Open menu">
        <i class="fa-solid fa-bars"></i>
      </button>

      <div class="d-flex align-items-center gap-3">
        <img src="logo.jpg" alt="Logo" class="logo-square" onerror="this.style.display='none'">
        <div>
          <h5 class="mb-0 fw-bold">Office Management System</h5>
          <small class="text-white-75">Valvettithurai Urban Council</small>
        </div>
      </div>
    </div>

    <div class="d-flex align-items-center flex-wrap gap-2">
      <span class="badge rounded-pill"><i class="fa-solid fa-user-shield me-1"></i>Role: Letter Admin</span>
      <span class="badge rounded-pill"><i class="fa-solid fa-user-tie me-1"></i><?= $username; ?></span>
      <a href="logout.php" class="btn btn-outline-light btn-sm">
        <i class="fa-solid fa-right-from-bracket me-1"></i> Logout
      </a>
    </div>
  </div>

  <div class="container-fluid py-3">

    <!-- KPI GRID -->
    <div class="row g-3">
      <div class="col-12 col-sm-6 col-xl-4">
        <div class="card kpi h-100 p-3">
          <div class="d-flex align-items-center justify-content-between">
            <div>
              <div class="label">Pending (Branch Head)</div>
              <div class="value"><?= $pending_count; ?></div>
            </div>
            <div class="icon"><i class="fa-solid fa-hourglass-half"></i></div>
          </div>
        </div>
      </div>

      <div class="col-12 col-sm-6 col-xl-4">
        <div class="card kpi h-100 p-3">
          <div class="d-flex align-items-center justify-content-between">
            <div>
              <div class="label">Received (Not Assigned)</div>
              <div class="value"><?= $received_count; ?></div>
            </div>
            <div class="icon"><i class="fa-solid fa-box-open"></i></div>
          </div>
        </div>
      </div>

      <div class="col-12 col-sm-6 col-xl-4">
        <div class="card kpi h-100 p-3">
          <div class="d-flex align-items-center justify-content-between">
            <div>
              <div class="label">Seen by Staff</div>
              <div class="value"><?= $seen_count; ?></div>
            </div>
            <div class="icon"><i class="fa-solid fa-eye"></i></div>
          </div>
        </div>
      </div>

      <div class="col-12 col-sm-6 col-xl-4">
        <div class="card kpi h-100 p-3">
          <div class="d-flex align-items-center justify-content-between">
            <div>
              <div class="label">Action Taken</div>
              <div class="value"><?= $action_count; ?></div>
            </div>
            <div class="icon"><i class="fa-solid fa-circle-check"></i></div>
          </div>
        </div>
      </div>

      <div class="col-12 col-sm-6 col-xl-4">
        <div class="card kpi h-100 p-3">
          <div class="d-flex align-items-center justify-content-between">
            <div>
              <div class="label">No Action</div>
              <div class="value"><?= $no_action_count; ?></div>
            </div>
            <div class="icon"><i class="fa-solid fa-triangle-exclamation"></i></div>
          </div>
        </div>
      </div>

      <div class="col-12 col-sm-6 col-xl-4">
        <div class="card kpi h-100 p-3">
          <div class="d-flex align-items-center justify-content-between">
            <div>
              <div class="label">Not Seen by Staff</div>
              <div class="value"><?= $not_seen_count; ?></div>
            </div>
            <div class="icon"><i class="fa-solid fa-eye-slash"></i></div>
          </div>
        </div>
      </div>
    </div>

    <!-- LETTER MANAGEMENT -->
    <h6 class="section-title">Letter Management</h6>
    <div class="row g-3">
      <div class="col-12 col-md-6 col-xl-3">
        <a href="action_yes_letters.php" class="btn btn-primary btn-tile">
          <span class="text-start">
            <div class="fw-bold">Taken Action Letters</div>
            <small>Completed by staff</small>
          </span>
          <i class="fa-solid fa-check-circle"></i>
        </a>
      </div>

      <div class="col-12 col-md-6 col-xl-3">
        <a href="pending_with_branch_head.php" class="btn btn-danger btn-tile">
          <span class="text-start">
            <div class="fw-bold">Not Received by Branch Head</div>
            <small>Pending acknowledgement</small>
          </span>
          <i class="fa-solid fa-times-circle"></i>
        </a>
      </div>

      <div class="col-12 col-md-6 col-xl-3">
        <a href="received_not_forward_staff.php" class="btn btn-info btn-tile">
          <span class="text-start">
            <div class="fw-bold">Received • Not Assigned</div>
            <small>Assign to staff</small>
          </span>
          <i class="fa-solid fa-arrow-right"></i>
        </a>
      </div>

      <div class="col-12 col-md-6 col-xl-3">
        <a href="not_seen_letters.php" class="btn btn-dark btn-tile">
          <span class="text-start">
            <div class="fw-bold">Not Seen by Staff</div>
            <small>Follow up required</small>
          </span>
          <i class="fa-solid fa-eye-slash"></i>
        </a>
      </div>

      <div class="col-12 col-md-6 col-xl-3">
        <a href="seen_letters.php" class="btn btn-warning btn-tile">
          <span class="text-start">
            <div class="fw-bold">Seen – No Action</div>
            <small>Awaiting response</small>
          </span>
          <i class="fa-solid fa-eye"></i>
        </a>
      </div>

      <div class="col-12 col-md-6 col-xl-3">
        <a href="sent_all_letters.php" class="btn btn-secondary btn-tile">
          <span class="text-start">
            <div class="fw-bold">Sent — All</div>
            <small>All outgoing</small>
          </span>
          <i class="fa-solid fa-paper-plane"></i>
        </a>
      </div>

      <div class="col-12 col-md-6 col-xl-3">
        <a href="3days.php" class="btn btn-outline-secondary btn-tile">
          <span class="text-start">
            <div class="fw-bold">3–7 Days • No Action</div>
            <small>Time-sensitive</small>
          </span>
          <i class="fa-solid fa-hourglass-half"></i>
        </a>
      </div>
    </div>

    <!-- OPTIONAL: Letter Status Management shortcuts -->
    <h6 class="section-title">Letter Status Management</h6>
    <div class="row g-3 mb-4">
      <div class="col-12 col-md-6 col-xl-3">
        <a href="unauthorized.php" class="btn btn-danger btn-tile">
          <span class="text-start">
            <div class="fw-bold">Process A</div>
            <small>Restricted (demo)</small>
          </span>
          <i class="fa-solid fa-arrow-right"></i>
        </a>
      </div>
      <div class="col-12 col-md-6 col-xl-3">
        <a href="unauthorized.php" class="btn btn-success btn-tile">
          <span class="text-start">
            <div class="fw-bold">Process B</div>
            <small>Restricted (demo)</small>
          </span>
          <i class="fa-solid fa-arrow-right"></i>
        </a>
      </div>
      <div class="col-12 col-md-6 col-xl-3">
        <a href="unauthorized.php" class="btn btn-secondary btn-tile">
          <span class="text-start">
            <div class="fw-bold">Process C</div>
            <small>Restricted (demo)</small>
          </span>
          <i class="fa-solid fa-arrow-right"></i>
        </a>
      </div>
    </div>

  </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz"
        crossorigin="anonymous"></script>
</body>
</html>
