<?php
session_start();

// Check if the user is logged in and has the Admin role
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'letter_admin') {
    header('Location: unauthorized.php');
    exit();
}

// Include the database connection file
include 'db_connection.php';

// Initialize the count variables
$pending_count = 0;
$received_count = 0;
$seen_count = 0;
$action_count = 0;
$no_action_count = 0;
$not_seen_count = 0;

// Initialize filter variables
$start_date = $end_date = $branch_id = "";

// Prepare the query to count 'pending', 'received', 'seen', 'action', 'no action' and 'not seen' statuses
$query = "SELECT 
            COUNT(CASE WHEN letters.status_branch_head = 'pending' THEN 1 END) AS pending_count,
            COUNT(CASE WHEN letters.status_branch_head = 'received' THEN 1 END) AS received_count,
            COUNT(CASE WHEN letters.seen = 1 THEN 1 END) AS seen_count,
            COUNT(CASE WHEN letters.action = 'yes' THEN 1 END) AS action_count,
            COUNT(CASE WHEN letters.action IS NULL OR letters.action = '' THEN 1 END) AS no_action_count,
            COUNT(CASE WHEN letters.seen IS NULL OR letters.seen = '' THEN 1 END) AS not_seen_count
          FROM letters
          WHERE 1";

// Apply date range filter if provided
if (isset($_POST['start_date']) && isset($_POST['end_date']) && $_POST['start_date'] != '' && $_POST['end_date'] != '') {
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];
    $query .= " AND letters.letter_date BETWEEN '$start_date' AND '$end_date'";
}

// Apply branch filter if provided
if (isset($_POST['branch_id']) && $_POST['branch_id'] != '') {
    $branch_id = $_POST['branch_id'];
    $query .= " AND letters.branch_id = '$branch_id'";
}

// Execute the query
$result = $conn->query($query);

// Check if there are any results
if ($result) {
    $row = $result->fetch_assoc();
    $pending_count = $row['pending_count'];
    $received_count = $row['received_count'];
    $seen_count = $row['seen_count'];
    $action_count = $row['action_count'];
    $no_action_count = $row['no_action_count'];
    $not_seen_count = $row['not_seen_count'];
} else {
    $pending_count = 0;
    $received_count = 0;
    $seen_count = 0;
    $action_count = 0;
    $no_action_count = 0;
    $not_seen_count = 0;
}

// Fetch all branches for the filter dropdown
$branches = $conn->query("SELECT branch_id, branch_name FROM branches");

// Close the database connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Status Counts - Letter Admin</title>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha512-..." crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f7fc;
            padding: 20px;
        }

        .sidebar {
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            width: 250px;
            background-color: #222;
            color: white;
            padding-top: 20px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 12px;
            font-size: 16px;
            border-bottom: 1px solid #444;
        }

        .sidebar a:hover {
            background-color: #555;
        }

        .main-content {
            margin-left: 250px;
            padding: 20px;
        }

        header {
            background-color: #007bff;
            color: white;
            padding: 15px;
            text-align: center;
            margin-bottom: 20px;
        }

        footer {
            background-color: #343a40;
            color: white;
            text-align: center;
            padding: 10px;
            position: fixed;
            bottom: 0;
            width: 100%;
        }

        .card {
            border: none;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            transition: transform 0.2s ease-in-out;
        }

        .card:hover {
            transform: scale(1.05);
        }

        .card-body {
            text-align: center;
            font-size: 18px;
        }

        .count-box {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .count-box div {
            width: 23%;
            text-align: center;
            background-color: #007bff;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            color: white;
        }

        .count-box div:hover {
            background-color: #0056b3;
        }

        .navbar {
            background-color: #222;
            color: white;
        }

        .navbar .navbar-nav .nav-link {
            color: white;
        }

        .navbar .navbar-nav .nav-link:hover {
            color: #007bff;
        }
    </style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar">
    <h4 class="text-center text-white">Letter Admin</h4>
    <a href="letter_admin_dashboard.php">Dashboard</a>
    <a href="report.php">Report</a>
    <a href="sent_all_letters.php">Sent All Letters</a>
    <a href="enter_letter.php">Assign Letters</a>
    <a href="logout.php" class="text-danger">Logout</a>
</div>

<!-- Main Content -->
<div class="main-content">
    <header>
        <h2>Letter Tracking System - Thunukkai DS office</h2>
        <p>Welcome, <strong>Letter Admin</strong> <span id="username"><?php echo $_SESSION['username']; ?></span></p>
    </header>

    <!-- Filter Form -->
    <form action="report.php" method="POST">
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="start_date">Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?php echo $start_date; ?>">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="end_date">End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?php echo $end_date; ?>">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="branch_id">Branch</label>
                    <select name="branch_id" class="form-control">
                        <option value="">Select Branch</option>
                        <?php while ($branch = $branches->fetch_assoc()): ?>
                            <option value="<?php echo $branch['branch_id']; ?>" <?php if ($branch_id == $branch['branch_id']) echo 'selected'; ?>>
                                <?php echo $branch['branch_name']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary mt-4">Apply Filters</button>
            </div>
        </div>
    </form>

    <!-- Counts Display -->
    <div class="count-box">
        <div>
            <strong>Pending Count:</strong>
            <div><?php echo $pending_count; ?></div>
        </div>
        <div>
            <strong>Received Count:</strong>
            <div><?php echo $received_count; ?></div>
        </div>
        <div>
            <strong>Seen Count:</strong>
            <div><?php echo $seen_count; ?></div>
        </div>
        <div>
            <strong>Action Count:</strong>
            <div><?php echo $action_count; ?></div>
        </div>
    </div>

    <!-- Cards with Actions -->
    <div class="row">
        <!-- Card 1 -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Branch Head Pending Letters</h5>
                    <p class="card-text">Letters assigned to the branch head but still pending assignment to staff.</p>
                    <a href="pending_with_branch_head.php" class="btn btn-primary btn-dashboard"><i class="fas fa-clipboard"></i> Pending Assign</a>
                </div>
            </div>
        </div>

        <!-- Card 2 -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Received Not Forwarded Letters</h5>
                    <p class="card-text">Letters received by the branch head but not forwarded to the staff.</p>
                    <a href="received_not_forward_staff.php" class="btn btn-success btn-dashboard"><i class="fas fa-search"></i> Not Forward Letters</a>
                </div>
            </div>
        </div>

        <!-- Card 3 -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Seen but No Action Taken</h5>
                    <p class="card-text">Letters that have been seen by staff but no action has been taken yet.</p>
                    <a href="seen_letters.php" class="btn btn-warning btn-dashboard"><i class="fas fa-arrow-right"></i> Seen - No Action</a>
                </div>
            </div>
        </div>
        <!-- Card 3 -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Seen but No Action Taken</h5>
                    <p class="card-text">Letters that have been seen by staff but no action has been taken yet.</p>
                    <a href="not_seen_letters.php" class="btn btn-warning btn-dashboard"><i class="fas fa-arrow-right"></i> Seen - No Action</a>
                </div>
            </div>
        </div>                    
        <!-- Card 3 -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Seen but No Action Taken</h5>
                    <p class="card-text">Letters that have been seen by staff but no action has been taken yet.</p>
                    <a href="action_yes_letters.php" class="btn btn-warning btn-dashboard"><i class="fas fa-arrow-right"></i> Seen - No Action</a>
                </div>
            </div>
        </div>
        <!-- Card 3 -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Seen but No Action Taken</h5>
                    <p class="card-text">Letters that have been seen by staff but no action has been taken yet.</p>
                    <a href="report.php" class="btn btn-warning btn-dashboard"><i class="fas fa-arrow-right"></i> Seen - No Action</a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Footer -->
<footer>
    <p>&copy; 2025 Divisional Secretariat, Thunukkai</p>
</footer>

<!-- Bootstrap JS and dependencies -->
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>

</body>
</html>
